/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved  *
*************************************************************************

*************************************************************************
*                                                                       *
*               EEPROM Emulation Driver for S12XS/S12P                  *
*                                                                       *
* FILE NAME     :  DFlashProgram.c                                      *
* DATE          :  06.04.2008                                           *
*                                                                       *
* AUTHOR        :  Infosys Team, Mysore                                 *
* E-mail        :  r56611@freescale.com                                 *
*                                                                       *
************************************************************************/


/******************************* CHANGES ********************************
 0.0a   10.09.2007      Sindhu R01      Initial Version
 1.0    06.04.2008      Sindhu R01      Removed the SSD Configuration
                                        structure. CallBack and
                                        commandArray are global variables.
                                        Pointer to FlashCommandSequence is
                                        removed.
************************************************************************/

#include "SSD_Types.h"
#include "SSD_SGF18.h"
#include "SSD_SGF18_Internal.h"


/************************************************************************
*
*  Function Name    : DFlashProgram.c
*  Description      : Program data into D Flash
*
*  Arguments        : UINT32, UINT32, UINT32
*  Return Value     : UINT16
*
*************************************************************************/

UINT16 DFlashProgram(UINT32 dest, UINT32 size, UINT32 source)
{
    UINT8  counter;         /* outer loop counter */
    UINT8  index;           /* command index */
    UINT8  loopIndex;       /* inner loop index */
    UINT16 tempValue;
    UINT16 commandValue;    /* store command value */
    UINT16 globalAddress;   /* store global address bits */
    UINT16 returnCode;      /* return code variable */
    UINT32 endAddress;      /* end address for the program operation */

    returnCode = SGF_OK;

    /* check the size alignment */
    if (0 != size % HCS12X_WORD_SIZE)
    {
        returnCode = SGF_ERR_SIZE;
    }
    else
    {
        /* calculate end address */
        endAddress = dest + size;

        /* check the range of the address */
        if(endAddress > (UINT32)DFLASH_BLOCK_END_ADDR)
        {
            returnCode = SGF_ERR_RANGE;
        }
        else
        {
            commandValue = (((UINT16)(DFLASH_PROGRAM)) << 8);
            while (dest < endAddress)
            {
                /* preparing passing parameter for program once command */
                globalAddress =(UINT16)((dest & GLOBAL_ADDRESS_MASK) >> 16);
                /* 1st element for the FCCOB register */
                commandArray[0] = (commandValue|globalAddress);
                /* 2nd element fot the FCCOB register */
                commandArray[1] = (UINT16)(dest & ADDRESS_OFFSET_MASK);
                if(size > FLASH_PHRASE_SIZE)
                {
                    loopIndex = COMMAND_INDEX4;
                }
                else
                {
                    loopIndex = (UINT8)(size/HCS12X_WORD_SIZE);
                }

                /* preparing rest of the parameters for FCCOB register */
                for (counter = 0; counter < loopIndex; counter++)
                {
                    tempValue = READ16(source);
                    commandArray[counter + 2] = tempValue;
                    dest += HCS12X_WORD_SIZE;
                    source += HCS12X_WORD_SIZE;
                    size -= HCS12X_WORD_SIZE;
                }

                index = loopIndex + 1; /* value of FCCOBIX at command launch */

                /* calling flash command sequence API to execute the command */
                returnCode = FlashCommandSequence( index );

                /* checking for the success of command execution */
                if(SGF_OK != returnCode)
                {
                    break;
                }
            }
        }
    }

    return(returnCode);
}
